package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.models.ReporteCreditos;
import com.example.sefinsa_app.models.ReporteDiario;
import com.google.android.material.chip.Chip;
import com.google.android.material.chip.ChipGroup;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;

import java.util.ArrayList;

public class ReporteCreditosAdapter extends RecyclerView.Adapter<ReporteCreditosAdapter.ReporteCreditosViewHolder>{


    Context context;
    public ArrayList<ReporteCreditos> reportes;
    public ArrayList<ReporteCreditos> reportesSeleccionados = new ArrayList<>();
    public ArrayList<ReporteCreditos> reportesEditados = new ArrayList<>();

    public boolean buscarReporte = false;
    public ChipGroup chipGroup2;

    public ReporteCreditosAdapter(Context context,ArrayList<ReporteCreditos> reportes) {
        this.context = context;
        this.reportes = reportes;
    }

    public void setBuscarReporte(boolean buscarReporte){
        this.buscarReporte = buscarReporte;
    }


    @NonNull
    @Override
    public ReporteCreditosAdapter.ReporteCreditosViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(context).inflate(R.layout.reporte_diario_item, parent, false);
        return new ReporteCreditosAdapter.ReporteCreditosViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ReporteCreditosAdapter.ReporteCreditosViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public void clear() {
        reportes.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<ReporteCreditos> list) {
        reportes = list;
        notifyDataSetChanged();
    }

    public void setListaFiltrada(ArrayList<ReporteCreditos>filteredList){
        this.reportes = filteredList;
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        return reportes.size();
    }

    public class ReporteCreditosViewHolder extends RecyclerView.ViewHolder {

        TextView tvPoblacion, tvEstimado;

        ConstraintLayout reporte_diario_item_bg;

        Button btnFormulario;

        public ReporteCreditosViewHolder(@NonNull View itemView) {
            super(itemView);

            tvPoblacion = itemView.findViewById(R.id.tvPoblacion);
            tvEstimado = itemView.findViewById(R.id.tvEstimado);
            btnFormulario = itemView.findViewById(R.id.btnVerPagos);
            reporte_diario_item_bg = itemView.findViewById(R.id.reporte_diario_item_bg);

        }

        public void imprimir(int position) {

            tvPoblacion.setText(reportes.get(position).getNombre_poblacion());
            tvEstimado.setText("");

            if(reportes.get(position).getSeleccionado()){
                reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));

                if(!buscarReporte){
                    reporte_diario_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                        @Override
                        public boolean onLongClick(View view) {
                            reportes.get(position).setSeleccionado(false);
                            reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
                            reportesSeleccionados.remove(reportes.get(position));
                            return false;
                        }
                    });
                }

            }
            else{
                reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
            }

            btnFormulario.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {

                    final View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_reporte_creditos, null, false);

                    Button btnAgregar = dialogView.findViewById(R.id.btnAgregar);
                    TextInputLayout tlObservaciones = dialogView.findViewById(R.id.tlObservaciones);
                    tlObservaciones.getEditText().setText(reportes.get(position).getObservaciones());
                    TextInputLayout tlMonto = dialogView.findViewById(R.id.tlMonto);
                    TextInputLayout tlCantidad = dialogView.findViewById(R.id.tlCantidad);
                    TextInputLayout tlTotalPrestamos = dialogView.findViewById(R.id.tlTotalPrestamos);
                    tlTotalPrestamos.getEditText().setText(reportes.get(position).getTotal_prestamos());
                    TextInputLayout tlPrestamosNuevos = dialogView.findViewById(R.id.tlPrestamosNuevos);
                    tlPrestamosNuevos.getEditText().setText(reportes.get(position).getPrestamos_nuevos());
                    TextInputLayout tlMontoNuevos = dialogView.findViewById(R.id.tlMontoNuevos);
                    tlMontoNuevos.getEditText().setText(reportes.get(position).getMonto_nuevos());
                    TextInputLayout tlPrestamosRenovados = dialogView.findViewById(R.id.tlPrestamosRenovados);
                    tlPrestamosRenovados.getEditText().setText(reportes.get(position).getPrestamos_renovados());
                    TextInputLayout tlMontoRenovados = dialogView.findViewById(R.id.tlMontoRenovados);
                    tlMontoRenovados.getEditText().setText(reportes.get(position).getMonto_renovados());
                    ChipGroup chipGroup = dialogView.findViewById(R.id.chipGroup);
                    TextView tvCreditos = dialogView.findViewById(R.id.tvCreditos);

                    if(reportes.get(position).getCreditos_otorgados() != null){

                        String[] creditosSplit = reportes.get(position).getCreditos_otorgados().trim().split("\\$");


                        for(int i = 0; i < creditosSplit.length; i++){

                            if(!creditosSplit[i].equals("")  && !creditosSplit[i].equals("null ") && !creditosSplit[i].equals(" ")){

                                Chip chip = new Chip(context);
                                chip.setCloseIconVisible(true);
                                chip.setChipBackgroundColorResource(R.color.orange_700);
                                String chipText = "$"+creditosSplit[i];
                                chip.setText(chipText);

                                chip.setOnCloseIconClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View view) {
                                        reportes.get(position).setCreditos_otorgados(reportes.get(position).getCreditos_otorgados().replace(chipText, ""));
                                        chipGroup.removeView(chip);

                                        String[] creditosSplit = reportes.get(position).getCreditos_otorgados().trim().split("\\$");

                                        int total = 0;

                                        for(int i = 0; i < creditosSplit.length; i++){

                                            if(!creditosSplit[i].equals("")  && !creditosSplit[i].equals("null ") && !creditosSplit[i].equals(" ")){
                                                total += Integer.parseInt(creditosSplit[i].split(" ")[1].replace("(","").replace(")", ""));

                                            }

                                        }
                                        reportes.get(position).setTotal_prestamos(String.valueOf(total));
                                        tlTotalPrestamos.getEditText().setText(String.valueOf(total));

                                    }
                                });

                                /*int total = Integer.parseInt(reportes.get(position).getTotal_prestamos());
                                tlTotalPrestamos.getEditText().setText(String.valueOf(total));*/

                                chipGroup.addView(chip);

                            }
                        }
                    }


                    btnAgregar.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {

                            if (!tlMonto.getEditText().getText().toString().equals("")
                                    && !tlCantidad.getEditText().getText().toString().equals("")){

                                String chipText = "$"+tlMonto.getEditText().getText().toString()+ " (" + tlCantidad.getEditText().getText().toString()+")";

                                boolean dataValid = true;

                                if(reportes.get(position).getCreditos_otorgados() != null){

                                    if(reportes.get(position).getCreditos_otorgados().contains(chipText)
                                            || reportes.get(position).getCreditos_otorgados().contains("$"+tlMonto.getEditText().getText().toString())
                                            && reportes.get(position).getCreditos_otorgados() != null){
                                        Toast.makeText(context, "Este monto ya fue ingresado", Toast.LENGTH_SHORT).show();
                                        dataValid = false;
                                    }
                                    else{
                                        dataValid = true;
                                    }

                                }

                                if(dataValid){

                                    Chip chip = new Chip(context);
                                    chip.setCloseIconVisible(true);
                                    chip.setChipBackgroundColorResource(R.color.orange_700);
                                    chip.setText(chipText);

                                    chip.setOnCloseIconClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View view) {
                                            reportes.get(position).setCreditos_otorgados(reportes.get(position).getCreditos_otorgados().replace(chipText, ""));
                                            chipGroup.removeView(chip);
                                        }
                                    });

                                    reportes.get(position).setCreditos_otorgados(reportes.get(position).getCreditos_otorgados() + " "+ chipText);

                                    chipGroup.addView(chip);

                                    String[] creditosSplit = reportes.get(position).getCreditos_otorgados().trim().split("\\$");

                                    int total = 0;

                                    for(int i = 0; i < creditosSplit.length; i++) {

                                        if(!creditosSplit[i].equals("") && !creditosSplit[i].equals("null ") && !creditosSplit[i].equals(" ")){
                                            total += Integer.parseInt(creditosSplit[i].split(" ")[1].replace("(","").replace(")", ""));
                                        }

                                    }

                                    reportes.get(position).setTotal_prestamos(String.valueOf(total));
                                    tlTotalPrestamos.getEditText().setText(String.valueOf(total));

                                    tlMonto.getEditText().setText("");
                                    tlCantidad.getEditText().setText("");
                                    tlMonto.requestFocus();

                                }


                            }
                        }
                    });

                    new MaterialAlertDialogBuilder(context)
                            .setCancelable(false)
                            .setView(dialogView)
                            .setTitle(reportes.get(position).getNombre_poblacion())
                            .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {


                                    if(!buscarReporte){

                                        reportes.get(position).setSeleccionado(true);
                                        reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                                        if(!reportesSeleccionados.contains(reportes.get(position))){
                                            reportesSeleccionados.add(reportes.get(position));
                                        }

                                        reporte_diario_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                                            @Override
                                            public boolean onLongClick(View view) {
                                                reportes.get(position).setSeleccionado(false);
                                                reporte_diario_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
                                                reportesSeleccionados.remove(reportes.get(position));
                                                return false;
                                            }
                                        });

                                    }

                                    reportes.get(position).setObservaciones(tlObservaciones.getEditText().getText().toString());
                                    reportes.get(position).setTotal_prestamos(tlTotalPrestamos.getEditText().getText().toString());
                                    reportes.get(position).setPrestamos_nuevos(tlPrestamosNuevos.getEditText().getText().toString());
                                    reportes.get(position).setMonto_nuevos(tlMontoNuevos.getEditText().getText().toString());
                                    reportes.get(position).setPrestamos_renovados(tlPrestamosRenovados.getEditText().getText().toString());
                                    reportes.get(position).setMonto_renovados(tlMontoRenovados.getEditText().getText().toString());

                                    if(buscarReporte){
                                        reportesEditados.add(reportes.get(position));
                                    }

                                }
                            })
                            .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {


                                }
                            })
                            .show();

                }
            });


        }
    }


}
